package gov.va.genisis2.bo;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import gov.va.genisis2.common.enums.CommonEnum;
import gov.va.genisis2.common.enums.WorkflowStatusEnum;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.model.User;
import gov.va.genisis2.vo.EmailDetails;

@Component
public class EmailHelper {
	private static final String EMAILID_DELIMETER = ",";
	private static final String CANCEL_REQUEST = "Cancel";

	public void populateEmailDetailsForSubmit(JSONObject json, int requestId, Request request, User requesterUsers, String requestorId, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), "");

		String emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		String emailRecipient = extractEmailIds(StringUtils.EMPTY, admins, ddms);
		String emailSubject = "ACTION REQUIRED: Submitted Request - " + requestId + " - " + request.getTitle();
		String emailBody = "A new data request " + requestId + " has been Submitted by " + requestorId + " for review. ";
		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		
		emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		emailRecipient = (null != requesterUsers) ? requesterUsers.getEmailId() : null;
		emailSubject = "Submitted Request - " + requestId + " - " + request.getTitle();
		emailBody = "Your new data request " + requestId + " has been Submitted for review. ";
		emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForReturned(JSONObject json, int requestId, Request request, String comments, User requesterUsers) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), "Return");
		
		String emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		String emailRecipient = (null != requesterUsers) ? requesterUsers.getEmailId() : null;
		String emailSubject = "Returned Request - " + requestId + " - " + request.getTitle();
		String emailBody = "Your data request " + requestId + "  has been Returned." + System.lineSeparator();
		emailBody = emailBody + CommonEnum.EMAIL_COMMENTS.getText() + comments;
		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForDenied(JSONObject json, int requestId, Request request, String comments, User requesterUsers) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), "Reject");
		
		String emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		String emailRecipient = (null != requesterUsers) ? requesterUsers.getEmailId() : null;
		String emailSubject = "Request Denied  - " + requestId + " - " + request.getTitle();
		String emailBody = "Your data request " + requestId + "  has been Denied." + System.lineSeparator();
		emailBody = emailBody + CommonEnum.EMAIL_COMMENTS.getText() + comments;
		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForSent(JSONObject json, int requestId, Request request, String comments, RequestType requestType, Source source, StudyApproval studyApproval, User requesterUsers, List<User> admins, List<User> dsms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), "Sent");

		String emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		String emailRecipient = extractEmailIds(StringUtils.EMPTY, admins, dsms);
		String emailSubject = "ACTION REQUIRED: Genisis Data Request - " + requestId + " - " + request.getTitle();
		String emailBody = "A new " + requestType.getDescription() + " data request " + requestId + " has been reviewed and determined to have sufficient information for data research. " + System.lineSeparator();
		emailBody = emailBody + "Request ID: " + requestId + System.lineSeparator();
		emailBody = emailBody + "Request Type: " + requestType.getDescription() + System.lineSeparator();
		emailBody = emailBody + "Data Source: " + source.getDescription() + System.lineSeparator();
		emailBody = emailBody + "Approved Study: " + studyApproval.getDescription() + System.lineSeparator();
		emailBody = emailBody + "Description: " + request.getDescription() + System.lineSeparator();
		emailBody = emailBody + CommonEnum.EMAIL_COMMENTS.getText() + comments;
		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		
		emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		emailRecipient = (null != requesterUsers) ? requesterUsers.getEmailId() : null;
		emailSubject = "Approved Request - " + requestId +" -" + request.getTitle()+ "  Approved";
		emailBody = "Your data request " + requestId + " has been Approved and sent to " + source.getDescription() + " for research.";
		emailBody = emailBody + CommonEnum.EMAIL_COMMENTS.getText() + comments;
		emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForNotAccepted(JSONObject json, int requestId, Request request, String comments, User requesterUsers, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), "Unfulfilled");
		
		String emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		String emailRecipient = (null != requesterUsers) ? requesterUsers.getEmailId() : null;
		
		String emailSubject = "Genisis Data Request Cannot Be Fulfilled  - " + requestId + " - " + request.getTitle();
		String emailBody = CommonEnum.EMAIL_YOUR_DATE_REQUEST.getText() + requestId + " Cannot Be Fulfilled.  " + System.lineSeparator();
		emailBody = emailBody + CommonEnum.EMAIL_COMMENTS.getText() + comments;
		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		
		emailRecipient = extractEmailIds(StringUtils.EMPTY, admins, ddms);
		emailBody = "Data Request " + requestId + " Cannot Be Fulfilled.  " + System.lineSeparator();
		emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForAccepted(JSONObject json, int requestId, Request request, String comments, User requesterUsers) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), "Fulfilled");
		json.put("cc_users", "");

		String emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		String emailRecipient = (null != requesterUsers) ? requesterUsers.getEmailId() : null;
		String emailSubject = "Genisis Data Request Accepted - " + requestId + " - " + request.getTitle();
		String emailBody = CommonEnum.EMAIL_YOUR_DATE_REQUEST.getText() + requestId + " has been Accepted for review.  " + System.lineSeparator();
		emailBody = emailBody + CommonEnum.EMAIL_COMMENTS.getText() + comments;
		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForResultsDelivered(JSONObject json, int requestId, Request request, String comments, User requesterUsers, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put("cc_users", "vinci.datasource@gmail.com");
		
		String emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		String emailRecipientDdms = extractEmailIds(StringUtils.EMPTY, admins, ddms);
		String emailSubject = "ACTION REQUIRED: Genisis Data Request  - " + requestId + " - " + request.getTitle();
		String emailBody = "The results from the research for  " + requestId + " are Completed and ready for your review.  " + System.lineSeparator();
		emailBody = emailBody + CommonEnum.EMAIL_COMMENTS.getText() + comments;
		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipientDdms, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		
		emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		String emailRecipient1 = (null != requesterUsers) ? requesterUsers.getEmailId() : null;
		emailSubject = "Genisis Data Request   - " + requestId + " - " + request.getTitle();
		emailBody = CommonEnum.EMAIL_YOUR_DATE_REQUEST.getText() + requestId + "  results were delivered for review." + System.lineSeparator();
		emailBody = emailBody + CommonEnum.EMAIL_COMMENTS.getText() + comments;
		emailDet = new EmailDetails(emailSender, emailRecipient1, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForResultsNotAccepted(JSONObject json, int requestId, Request request, String comments, User requesterUsers, List<User> admins, List<User> dsms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_RESULT_ACCEPTANCE_DECISION.getText(), "Reject");
		
		String emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		String emailRecipient = (null != requesterUsers) ? requesterUsers.getEmailId() : null;
		emailRecipient = extractEmailIds(emailRecipient, admins, dsms);
		String emailSubject = "Results Not  Accepted   - " + requestId + " - " + request.getTitle();
		String emailBody = "The results from the research of  " + requestId + " have been reviewed and Not Accepted." + System.lineSeparator();
		emailBody = emailBody + CommonEnum.EMAIL_COMMENTS.getText() + comments;
		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForResultsAccepted(JSONObject json, int requestId, Request request, String comments, User requesterUsers, List<User> admins, List<User> dsms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_RESULT_ACCEPTANCE_DECISION.getText(), "Accept");
		
		String emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		String emailRecipient = (null != requesterUsers) ? requesterUsers.getEmailId() : null;
		emailRecipient = extractEmailIds(emailRecipient, admins, dsms);
		String emailSubject = "Results  Accepted    - " + requestId + " - " + request.getTitle();
		String emailBody = "The results from the research of  " + requestId + "  have been reviewed and Accepted." + System.lineSeparator();
		emailBody = emailBody + CommonEnum.EMAIL_COMMENTS.getText() + comments;
		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForCancelledRequest(JSONObject json, int requestId, Request request, User requesterUsers, List<User> admins, List<User> ddms, List<User> dsms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		String emailRecipient = (null != requesterUsers) ? requesterUsers.getEmailId() : null;
		
		String status = StringUtils.trim(request.getStatusDescription());
		if (StringUtils.equals(request.getStatusDescription(), WorkflowStatusEnum.SUBMITTED.getDesc())) {
			json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), CANCEL_REQUEST);
			json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), StringUtils.EMPTY);
			json.put(CommonEnum.EMAIL_RESULTS_DELIVER_DECISION.getText(), StringUtils.EMPTY);
		}
		if (StringUtils.equals(request.getStatusDescription(), WorkflowStatusEnum.SENT.getDesc())) {
			json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), CANCEL_REQUEST);
			json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), StringUtils.EMPTY);
			json.put(CommonEnum.EMAIL_RESULTS_DELIVER_DECISION.getText(), StringUtils.EMPTY);
		}
		if (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.RETURNED.getDesc())) {
			json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), CANCEL_REQUEST);
			json.put(CommonEnum.EMAIL_RESULTS_DELIVER_DECISION.getText(), StringUtils.EMPTY);
			json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), StringUtils.EMPTY);
		}
		if (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.REQUESTACCEPTED.getDesc())) {
			json.put(CommonEnum.EMAIL_RESULTS_DELIVER_DECISION.getText(), CANCEL_REQUEST);
			json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), StringUtils.EMPTY);
			json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), StringUtils.EMPTY);
		}
		if (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.RESULTSDELIVERED.getDesc())) {
			json.put(CommonEnum.EMAIL_RESULT_ACCEPTANCE_DECISION.getText(), CANCEL_REQUEST);
			json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), StringUtils.EMPTY);
			json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), StringUtils.EMPTY);
		}
		if (null != status) {
			if (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.SENT.getDesc()) || StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.REQUESTACCEPTED.getDesc())) {
				emailRecipient = extractEmailIds(emailRecipient, ddms, dsms, admins);
			} else if (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.SUBMITTED.getDesc()) || StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.RETURNED.getDesc()) || StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.RESULTSDELIVERED.getDesc())) {
				emailRecipient = extractEmailIds(emailRecipient, ddms, admins);
			}
		}
		String emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		json.put("cc_users", StringUtils.EMPTY);
		String emailSubject = "Cancelled - " + requestId + " - " + request.getTitle();
		String emailBody = "Genisis2 Data Request " + requestId + " has been Cancelled";
		EmailDetails emailDetail = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDetail);
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}
	
	public void populateEmailDetailsForReturnToDDMRequest(JSONObject json, int requestId, Request request, String comments, User requesterUsers, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		
		String status = StringUtils.trim(request.getStatusDescription());
		if (null != status) {
			if (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.SENT.getDesc())) {
				json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), WorkflowStatusEnum.RETURNTODDM.getDesc());
			} else if (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.REQUESTACCEPTED.getDesc())) {
				json.put(CommonEnum.EMAIL_RESULTS_DELIVER_DECISION.getText(), WorkflowStatusEnum.RETURNTODDM.getDesc());
			}
		}
		
		json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), StringUtils.EMPTY);
		
		String emailSender = CommonEnum.EMAIL_NO_REPLY_SENDER.getText();
		String emailRecipient = (null != requesterUsers) ? requesterUsers.getEmailId() : null;
		emailRecipient=extractEmailIds(emailRecipient, admins, ddms);
		String emailSubject = "Returned to DDM  - " + requestId + " - " + request.getTitle();
		String emailBody = "Genisis2 Data Request " + requestId + "  has been Returned to DDM."+ System.lineSeparator();
		emailBody = emailBody + CommonEnum.EMAIL_COMMENTS.getText() + comments;
		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipient, emailSubject, emailBody, StringUtils.EMPTY);
		emailDetails.add(emailDet);
		
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}
	

	@SafeVarargs
	private final String extractEmailIds(String requesterEmail, List<User>... userList) {
		StringJoiner sj = new StringJoiner(EMAILID_DELIMETER);
		if (StringUtils.isNotBlank(requesterEmail)) {
			sj.add(requesterEmail);
		}
		if (null == userList || userList.length == 0) {
			return sj.toString();
		}
		for (List<User> users : userList) {
			if (null != users && !users.isEmpty()) {
				for (User user : users) {
					if (null != user && StringUtils.isNotBlank(user.getEmailId())) {
						sj.add(user.getEmailId());
					}
				}
			}
		}
		return sj.toString();
	}
}
